/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.internal.google.common.base.Function;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Predicate;
import org.sonar.api.internal.google.common.collect.FluentIterable;
import org.sonar.api.internal.google.common.collect.ImmutableSet;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;

public class TestMeasureComputerDefinition
implements MeasureComputer.MeasureComputerDefinition {
    private final Set<String> inputMetricKeys;
    private final Set<String> outputMetrics;

    private TestMeasureComputerDefinition(MeasureComputerDefinitionBuilderImpl builder) {
        this.inputMetricKeys = ImmutableSet.copyOf(builder.inputMetricKeys);
        this.outputMetrics = ImmutableSet.copyOf(builder.outputMetrics);
    }

    @Override
    public Set<String> getInputMetrics() {
        return this.inputMetricKeys;
    }

    @Override
    public Set<String> getOutputMetrics() {
        return this.outputMetrics;
    }

    private static void checkNotNull(String[] metrics) {
        for (String metric : metrics) {
            Objects.requireNonNull(metric, "Null metric is not allowed");
        }
    }

    private static class MatchMetricKey
    implements Predicate<String> {
        private final List<String> metrics;

        public MatchMetricKey(String[] metrics) {
            this.metrics = Arrays.asList(metrics);
        }

        @Override
        public boolean apply(@Nonnull String metric) {
            Preconditions.checkArgument(!this.metrics.contains(metric), "Core metrics are not allowed");
            return true;
        }
    }

    private static enum MetricToKey implements Function<Metric, String>
    {
        INSTANCE;


        @Override
        public String apply(@Nonnull Metric input) {
            return input.getKey();
        }
    }

    public static class MeasureComputerDefinitionBuilderImpl
    implements MeasureComputer.MeasureComputerDefinition.Builder {
        private String[] inputMetricKeys = new String[0];
        private String[] outputMetrics;

        @Override
        public MeasureComputer.MeasureComputerDefinition.Builder setInputMetrics(String ... inputMetrics) {
            this.inputMetricKeys = MeasureComputerDefinitionBuilderImpl.validateInputMetricKeys(inputMetrics);
            return this;
        }

        @Override
        public MeasureComputer.MeasureComputerDefinition.Builder setOutputMetrics(String ... outputMetrics) {
            this.outputMetrics = MeasureComputerDefinitionBuilderImpl.validateOutputMetricKeys(outputMetrics);
            return this;
        }

        @Override
        public MeasureComputer.MeasureComputerDefinition build() {
            MeasureComputerDefinitionBuilderImpl.validateInputMetricKeys(this.inputMetricKeys);
            MeasureComputerDefinitionBuilderImpl.validateOutputMetricKeys(this.outputMetrics);
            return new TestMeasureComputerDefinition(this);
        }

        private static String[] validateInputMetricKeys(@Nullable String[] inputMetrics) {
            Objects.requireNonNull(inputMetrics, "Input metrics cannot be null");
            TestMeasureComputerDefinition.checkNotNull(inputMetrics);
            return inputMetrics;
        }

        private static String[] validateOutputMetricKeys(@Nullable String[] outputMetrics) {
            Objects.requireNonNull(outputMetrics, "Output metrics cannot be null");
            Preconditions.checkArgument(outputMetrics.length > 0, "At least one output metric must be defined");
            FluentIterable.from(CoreMetrics.getMetrics()).transform(MetricToKey.INSTANCE).filter(new MatchMetricKey(outputMetrics)).size();
            TestMeasureComputerDefinition.checkNotNull(outputMetrics);
            return outputMetrics;
        }
    }
}

